<?php
/************************************************************************/
/* ivweather.class.php                                                  */
/* ===========================                                          */
/* Copyright (c) 2003 by David Rolston  (gizmo@gizmola.com)             */
/* http://www.gizmola.com                                               */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
// IVWeather.class.php retrieves free current and forecast weather      //
// information via xml from interceptvector.com, loads this data into   //
// an object and provides a few helpful member functions.               //
// See test_ivweather.php for examples of how to access the member      //
// variables and call the member functions.  See comments in class.		//
//																		//
// For information about the xml weather feeds,                         //
//   visit http://weather.interceptvector.com                           //
//                                                                      //
// This class is meant to be self contained and does not require        //
// anything besides standard php functionality. It does not use php's   //
// xml parsing libraries.                                               //
// To use, in your script require ivweather.class.php and Instantiate   //
// an IVWeather object:    $ivw = new IVWeather("URL");                 //
// For a list of URL's see http://weather.interceptvector.com/list.php  //
//                                                                      //
// if (!$ivw->err) should be checked immediately for success.           //
// Note:  Class requires allow_url_fopen=On in the php.ini              //
//																		//
// Version 1.1x introduced support for language localization files.     //
// If you choose to use the getLocal
// if ($localized)
//		$ivw->loadLocalization($rlangwd, $rlangsky);
// If you create a localized version please post it to the Tech forum   //
// at http://forum.gizmola.com/                                         //
//																		//
// Questions or comments can be left at http://forum.gizmola.com    	//
/************************************************************************/
// Version 1.10
// -Added version class variable to identify IVWeather class version
// -Fixed error handling to set $err and $errmsg, improved error handling
// ---Bad or invalid url's should now set $err and $errmsg
// -Added experimental timeout handling
// -Modified fopen() to include binary mode (rb)
// -Added "Calm" to getWinddecode
// -Created rDate[] for Date manipulation of IVWeather date.
// ----These Functions do not require localization file(s) ----------------
// -Added member function getDateStr()  -returns local Server Date/Time
// -Added member function SetLocalDateTimeFormat($sDTFmt) -override to set DateTime Format
// -Added member function getLocalDateStr()  -returns local Server Date/Time String
// -Added member function SetLocalFCDateFormat($sDFmt) -Sets Format for Forecast Dates
// -Added member function getLocalFCDateStr($date) -For formats other than mm/dd/yyyy
// ------------------------------------------------------------------------
// Translations provided by IVWeather.lang files.
// -Added support for localized string files
// ---Added getLocalWinddecode(language);
// ---Added getLocalWinddecode(language);
// ---Added getLocalSkybyWid(language); 
// ---Added getLocalSky(language); [returns today's Sky, locally translated]
/************************************************************************/
// Search for Localization files and include them
$localized=FALSE;
$thisdir=dirname(__FILE__);
clearstatcache();
$dir = opendir($thisdir);
while ($file=readdir($dir)) {
	$rFname = explode(".", $file);
	if (($rFname[0] == "ivweather") && ($rFname[1] == "lang") && ($rFname[3] == "php")) {
		$file = $thisdir . "/" .$file;
		include("$file");
	}
}
closedir($dir);
/************************************************************************/
define("UNDEF", "undef");
//class Def
class IVWeather {
	var $version = "1.10";
	// Properties	
	//
	// A Default $weatherurl
	var $weatherurl = "http://weather.interceptvector.com/weather.xml?id=VVNDQTEyMjU%3D";
	// Place holders for Global language Array
	var $rLangWD = array();
	var $rLangSky = array();
	var $rLangDateFmt = array("datetime" => "Y-m-d H:i:s", "date" => "Y-m-d");
	
	// Basic information identifying the location of the weather information
	var $rWeatherLocale = array("city" => UNDEF, "state" => UNDEF, "country" => UNDEF, "region" => UNDEF);
	//Parse Date Information
	var $rDate = array("dateOrig" => 0, "month"=> 0, "day" =>0, "year"=> 0, "timeOrig" => 0, "hour24" => 0, "minute" => 0, "seconds"=> 0, "TZOrig" => "", "dtGMT" => 0);
	
	// Datetime of the weather information.  All dates appear to be EST/EDT.  This is converted to GMT
	var $wdate;
	
	// Current temperature information.  Defaults to Fahrenheit.  See interceptvector for method of passing param to 
	// receive temp in celsius
	var $rTemp = array("temp" => 0, "realtemp", "tempscale" => UNDEF);
	
	var $rWind = array("direction" => UNDEF, "strength" => 0);
	var $barometer;
	var $humidity;
	var $uv;
	var $visibility;
	var $wid;
	// wid(weather id) corresponds to the weather description in sky.  
	// Sky is English only.
	var $sky;
	
	// Usually there are 5 days of forecasts.  
	// array("date" => UNDEF, "day" => UNDEF, "dtGMT" => 0, "high" => UNDEF,
	//       "low" => UNDEF, "wid" => UNDEF, "sky" => UNDEF, "precipitation" => UNDEF); 
	var $rForecast = array();
	var $fccnt = -1;
	
	// Providers is an array of information allowing acknowledgement of the providers
	//	array("name" => UNDEF, "url" => UNDEF, "logo" => UNDEF);
	var $rProvider = array();
	var	$provcnt = -1;
	var $err = FALSE;
	var $errmsg;
	

//methods
//IVWeather constructor.  Pass a valid IVWeather URL
//
	function IVWeather($pWeatherURL) {	
		global $localized;
		function gettag($pTagline) {			
			//$lrTag = array();
			$pTagLine = trim($pTagline);
			$lt = substr(strstr($pTagline, "<"),1);
			$lt = substr($lt,0,strpos($lt,">"));
			$rlt = explode(" ", $lt);
			$lt = $rlt[0];
			return $lt;
		}
		
		function gettagvalue($pTag, $pTagline) {
			$pTagLine = trim($pTagline);
			$ltgend = "</" . $pTag . ">";
			$e = strpos($pTagline, $ltgend);
			if ($e!==FALSE) {
				$ltgstart = "<" . $pTag . ">";
				$ltgsz = strlen($ltgstart);	
				$ltspos = strpos($pTagline, $ltgstart);	
				$lt = substr($pTagline, $ltspos+$ltgsz, (strpos($pTagline, $ltgend)-1) - $ltgsz - $ltspos + 1);	
			} else {
				$lt="";
			}
			return $lt;
		}
		
		function gettagparmvalue($pParm, $pTagline) {
			$pTagLine = trim($pTagline);
			$e = strpos($pTagline, $pParm);
			if ($e!==FALSE) {
				if (ereg("^.+$pParm=\"(.+)\"", $pTagline, $arr)) {
					$lt = $arr[1];
				}	
			} else {
				$lt="";
			}
			return $lt;
		}
		
		function setdt($strDate, &$rDate) {
		// Parse and Fill in the rDate array
		// EDT is GMT -4, EST is GMT -5
		
			$t = explode(" ", $strDate);
			$rDate['dateOrig']= $t[0];
			$td = explode("/", $rDate['dateOrig']);
			$rDate['month'] = $td[0];
			$rDate['day'] = $td[1];
			$rDate['year'] = $td[2];
			$rDate['timeOrig']= $t[1];
			$ts = explode(":", $rDate['timeOrig']);
			$rDate['hour24'] = $ts[0];
			$rDate['minute'] = $ts[1];
			$rDate['second'] = $ts[2];
			
			$rDate['TZOrig']= $t[2];
			$rDate['dtGMT'] = strtotime($strDate);			
 		}
		
		$lrFile = array();
		$this->weatherurl = $pWeatherURL;
		$lhandle = fopen($this->weatherurl, "rb");
		//echo "<!-- status: $lhandle -->";
		$this->errmsg = "Unable to open weather url";
		if (!$lhandle) {			
			$this->err = TRUE;
		} else {	
			socket_set_timeout($lhandle, 5);		
			while (!feof ($lhandle)) {
				$lbuffer = fgets($lhandle, 4096);
	  			$lrFile[] = $lbuffer;
			}
			fclose($lhandle);
			$this->err = FALSE;
		}
		// 
		if (!$this->err) {
			for ($i=0; $i<count($lrFile); $i++) {
				$ltag = gettag($lrFile[$i]);
				switch ($ltag) {
					case "provider" :
						$this->provcnt++;	
						$this->rProvider[] = array("name" => UNDEF, "url" => UNDEF, "logo" => UNDEF);
						break;
					case "forecast" :
						$this->fccnt++;
						$this->rForecast[] = array("date" => gettagparmvalue("date",$lrFile[$i]), "day" => UNDEF, "high" => UNDEF, "low" => UNDEF, "wid" => UNDEF, "sky" => UNDEF, "precipitation" => UNDEF); 
						break;
					case "city" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rWeatherLocale["city"]=$lval;
						break;
					case "state" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rWeatherLocale["state"]=$lval;
						break;
					case "country" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rWeatherLocale["country"]=$lval;
						break;
					case "region" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rWeatherLocale["region"]=$lval;
						break;
					case "date" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->wdate=$lval;
						setdt($this->wdate, $this->rDate);
						break;
					case "realtemp" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rTemp["realtemp"]=$lval;
						break;	
					case "temp" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rTemp["temp"]=$lval;
						break;
					case "tempScale" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rTemp["tempscale"]=$lval;
						break;
					case "direction" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rWind["direction"]=$lval;
						break;				
					case "strength" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rWind["strength"]=$lval;
						break;									
					case "barometer" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->barometer=$lval;
						break;						
					case "humidity" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->humidity=$lval;
						break;						
					case "uv" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->uv=$lval;
						break;		
					case "visibility" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->visibility=$lval;
						break;									
					case "wid" :
						if ($this->fccnt < 0 ) {
							$lval = gettagvalue($ltag, $lrFile[$i]);
							$this->wid=$lval;
						} else {
							$lval = gettagvalue($ltag, $lrFile[$i]);
							$this->rForecast[$this->fccnt]["wid"]=$lval;
						}
						break;				
					case "sky" :
						if ($this->fccnt < 0 ) {
							$lval = gettagvalue($ltag, $lrFile[$i]);
							$this->sky=$lval;
						} else {
							$lval = gettagvalue($ltag, $lrFile[$i]);
							$this->rForecast[$this->fccnt]["sky"]=$lval;
						}
						break;	
					case "name" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rProvider[$this->provcnt]["name"]=$lval;
						break;	
					case "url" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rProvider[$this->provcnt]["url"]=$lval;
						break;	
					case "logo" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rProvider[$this->provcnt]["logo"]=$lval;
						break;
					case "day" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rForecast[$this->fccnt]["day"]=$lval;
						break;			
					case "high" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rForecast[$this->fccnt]["high"]=$lval;
						break;		
					case "low" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rForecast[$this->fccnt]["low"]=$lval;
						break;		
					case "precipitation" :
						$lval = gettagvalue($ltag, $lrFile[$i]);
						$this->rForecast[$this->fccnt]["precipitation"]=$lval;
						break;						
				}
			}
		}
		// Check if we parsed ok
		if (!(isset($this->wid) && isset($this->wdate))) {
			$this->err=TRUE;
			$this->errmsg = "The site or URL was read, but contents were invalid.";
		}
	}
	
	// Initialize Localization support
	// Only required if you plan to use the getLocal... functions.
	function loadLocalization(&$rlangwd, &$rlangsky) {
		$this->rLangWD = $rlangwd;
		$this->rLangSky = $rlangsky;
	}

	
	// Returns localized version of the sky description for a wid number.
	function getLocalSkybyWid($language,$wid) {
		return $this->rLangSky[$language][$wid];
	}

	function getLocalSky($language) {
		return $this->getLocalSkybyWid($language, $this->wid);
	}
	
	// Returns local Date/Time This will be local relative to the php server.
	function getDateStr($fmtstr = "Y-m-d H:i:s") {
		// defaults to extended ISO 8601
		// Reference php date function for additional formating options
		return date($fmtstr,$this->rDate['dtGMT']);
	}
	
	// Set to override default format for calls to getLocalDateStr
	function SetLocalDateTimeFormat($sDTFmt) {
		$this->rLangDateFmt['datetime'] = $sDTFmt;
	}
	
	// Returns local Date or DateTime relative to locale of server.
	function getLocalDateStr() {
		// defaults to extended ISO 8601
		// call set 
		return date($this->rLangDateFmt['datetime'],$this->rDate['dtGMT']);		
	}

	// Set to override default format for calls to getLocalFCDateStr
	function SetLocalFCDateFormat($sDFmt) {	
		$this->rLangDateFmt['date'] = $sDFmt;
	}
	
	// Returns Forecast Date formatted to local preference.
	function getLocalFCDateStr($date) {
		// defaults to extended ISO 8601
		// call setLocalFCDateFormat to override default 
		$s = strtotime($date);
		return date($this->rLangDateFmt['date'],$s);		
	}
	
	// There can be a variable number of Forecasts
	// Use this to determine number for looping through the rForecast array
	function getForeCastCount() {
		return $this->fccnt+1;
	}
	// There can be a variable number of Providers
	// Use this to determine number for looping through the rProvider array
	function getProviderCount() {
		return $this->provcnt+1;
	}
	
	// Returns a Text description of the Wind Direction
	function getWinddecode() {
		$pt = $this->rWind["direction"];
		for ($i=0; $i < strlen($pt); $i++) {
			if ($i > 0) {
				$t .= " ";
			}
			switch ($pt[$i]) {
				case "C" :
					$t = "Calm";
					break;
				case "N" :  
					$t .= "North";
					break;
				case "S" :
					$t .= "South";
					break;
				case "E" :
					$t .= "East";
					break;
				case "W" : 
					$t .= "West";
					break;
			}			
		}		
		return rtrim($t);
	}
	
	// Returns a localized Text description of the Wind Direction.
	function getLocalWinddecode($lang) {
		$pt = $this->rWind["direction"];
		for ($i=0; $i < strlen($pt); $i++) {
			if ($i > 0) {
				$t .= " ";
			}
			switch ($pt[$i]) {
				case "C" :
					$t = $this->rLangWD[$lang]["C"];
					break;
				case "N" :  
					$t .= $this->rLangWD[$lang]["N"];
					break;
				case "S" :
					$t .= $this->rLangWD[$lang]["S"];
					break;
				case "E" :
					$t .= $this->rLangWD[$lang]["E"];
					break;
				case "W" : 
					$t .= $this->rLangWD[$lang]["W"];
					break;
			}			
		}		
		return rtrim($t);
	}
} // end class IVWeather
?>
