<?php
// ivweather.class.php pulls free weather information from http://weather.interceptvector.com/
// Please visit that site and read about the service they provide.
// They gather weather information from around the world and provide it via xml feeds.
// 
// This example script illustrates some of the standard abilities of the class, namely
// getting weather information and making it available to your php script through the inclusion of
// ivweather.class.php, and instantiating an IVWeather object: $ivw = new IVWeather($uvw);
// You can pass a valid ivweather url to this script and display that location's weather 
// by setting the u parameter.  
// The test script is installed here: http://canyoncam.gizmola.com/test_ivweather.php
//
// For example: 
// http://canyoncam.gizmola.com/test_ivweather.php?u=http://weather.interceptvector.com/weather.xml?id=UlNYWDAxMTY%3D
// will display weather information for Vladivostok, Russia.  A listing of locations and their respective ivweather url's
// is available at http://weather.interceptvector.com/list.php.
//
// Note that state appears to be empty for non-US locations, and some information may not available depending 
// the location, or the current weather conditions.
//
// The location of a .zip file containing the weather icons used in this demo can be found by
// visiting http://forum.gizmola.com/
//*****************
//Quickstart
//*****************
/* Your code should begin with this block.  You can pass a url variable like $uvw or a literal string.
 * For backwards compatibility with version 1.0 of the class, you can omit use of the localization block
 * if you don't need that support.

$ivw = new IVWeather($uvw);
if (!$ivw->err) {
	if ($localized)
		$ivw->loadLocalization($rlangwd, $rlangsky);
	* Your code here *
}
*/ 

$uvw = $HTTP_GET_VARS["u"];

if (!isset($uvw)) {
	// defaults to weather for Dublin, Ireland
	$uvw= "http://weather.interceptvector.com/weather.xml?id=RUlYWDAwMTQ%3D";
	//$uvw= "http://www.gizmola.com/weather.xml?id=RUlYWDAwMTQ%3D";
} 	
require("ivweather.class.php");

$ivw = new IVWeather($uvw);
if (!$ivw->err) {
	echo "<h3>Test of IVWeather class[<i>Version:$ivw->version!</i>]</h3><hr>";
	if ($localized)
		$ivw->loadLocalization($rlangwd, $rlangsky);
	echo "Weather for ". $ivw->rWeatherLocale["city"]. "," . $ivw->rWeatherLocale["state"] . " " . $ivw->rWeatherLocale["country"] . " " . $ivw->rWeatherLocale["region"] . "<br>";
	echo "Raw Date: $ivw->wdate <br><hr>";
	echo "Original Date:". $ivw->rDate['dateOrig'] ."&nbsp;&nbsp;";
	echo "Original Time:". $ivw->rDate['timeOrig'] ."&nbsp;&nbsp;";
	echo "Original TimeZone:". $ivw->rDate['TZOrig'] ."&nbsp;&nbsp;";
	echo "Timestamp GMT Value:". $ivw->rDate['dtGMT'] ."&nbsp;&nbsp;";
	echo "Month[". $ivw->rDate['month']."]&nbsp;&nbsp;";
	echo "Day[". $ivw->rDate['day']."]&nbsp;&nbsp;";
	echo "Year[". $ivw->rDate['year']."]&nbsp;&nbsp;<br>";
	echo "Local Date: ".$ivw->getDateStr() . "<br>";
	echo "Local Date/Americanized: ".$ivw->getDateStr("n-j-Y h:i:s A") . "<br><hr>";
	$ivw->SetLocalDateTimeFormat("n/j/Y h:i:s A");
	echo "Localization Date Formatted: ".$ivw->getLocalDateStr() . "<br><hr>";
	
	echo $ivw->rTemp["temp"] . " degrees " . $ivw->rTemp["tempscale"] . " and $ivw->sky <img src=http://weather.interceptvector.com/common/weather/icons/".$ivw->wid.".gif><br>(Spanish Translation:". $ivw->getLocalSky('spanish') .")<br>";
	echo "Wind speed " . $ivw->rWind["strength"] . "mph from " . $ivw->getWinddecode() . "[" . $ivw->rWind["direction"] . "]<br>";
	echo "Wind decode in Spanish: ". $ivw->getLocalWinddecode('spanish') ."<br>";
	echo "UV: $ivw->uv Visibility $ivw->visibility <br>";
	echo "Barometric pressure: ". $ivw->barometer . " and relative humidity of " . $ivw->humidity . "%<br><hr>";
	
	echo "<table>\n";
	echo "<tr>";
	for ($i=0; $i < $ivw->getForecastCount(); $i++) {
		echo "<td><b>" . $ivw->rForecast[$i]["day"] . "</b><br>". $ivw->rForecast[$i]["date"] ."<br>";
		echo "ISO:" . $ivw->getLocalFCDateStr($ivw->rForecast[$i]["date"]) . "<br>"; 
		echo "<img src=http://canyoncam.gizmola.com/images/weather/large/".$ivw->rForecast[$i]["wid"].".gif><br>";
		echo $ivw->rForecast[$i]["sky"]."<br>(".$ivw->getLocalSkybyWid('spanish',$ivw->rForecast[$i]["wid"]).")<br>high:".$ivw->rForecast[$i]["high"]."<br>low:".$ivw->rForecast[$i]["low"] . "<br>Chance Rain:".$ivw->rForecast[$i]["precipitation"]."%</td>";
	}
	echo "</tr>";
	echo "</table>\n";
	echo "<hr>Weather information provided by &nbsp<a href=" . $ivw->rProvider[0]["url"] . "><img border=0 src=\"" . $ivw->rProvider[0]["logo"] . "\" alt=\"". $ivw->rProvider[0]["name"] . "\"></a>";
	echo " and &nbsp<a href=" . $ivw->rProvider[1]["url"] . "><img border=0 src=\"" . $ivw->rProvider[1]["logo"] . "\" alt=\"". $ivw->rProvider[1]["name"] . "\"></a><br><hr>";
} else {
  echo "Problem: $ivw->errmsg";
}
?>
<table>
<br>
<tr><td>More information and support for this class can be found at the <a href=http://forum.gizmola.com/>Gizmola Forums</a></td></tr>
<tr><td>Weather icons used in this demonstration can be obtained by reading <a href=http://forum.gizmola.com/phpBB2/viewtopic.php?p=21>This message</a>.</td></tr>
</table>