<?php
/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2001 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
// Daoc_realm (English Version)											//
// David Rolston														//
//																		//
// PHP-Nuke 5.4 Compatible												//
/************************************************************************/
// Place This file in your NUKE blocks directory
// Use the Admin Blocks Menu and create a custom block
//
// From the File drop down menu select DAoC Realm.  Activate it and your block should
// appear.
// If you have questions you can leave me a message on the General Protectorites Forum 
// YES I KNOW THAT ALL THESE GLOBALS ARE HIDEOUS AND WRONG
//
/************************************************************************/
// DAoC Realm vs Realm v1.0, dhr 4/2002
// Pulls the realm war status from Camelot Herald. Check out http://www.camelotherald.com/xml.php
// -------------------------------------------------------------------------------------
// http://www.protectorites.com/
// 

if (eregi("block-DAoC_Realm2.php",$PHP_SELF)) {
    Header("Location: index.php");
    die();
}

function startRealmElement($parser, $tagName, $attrs) {    
global $tag, $da_servername, $da_servertype, $insideRelic, $insideKeep, $keeps, $keepCount, $skeepsOwned, $relics, $relicCount, $srelicsOwned, $sbgsOwned;	
	$tag = $tagName;
	if (strcmp($tagName, "SERVER") == 0) {
		$da_servername = rtrim($attrs["NAME"]);
		$da_servertype = $attrs["TYPE"];			
	} elseif (strcmp($tagName, "RELIC") == 0) {
		$insideRelic = true;
		$relicCount +=1;
		$relics[] = array ("name" =>$attrs["NAME"],
							"type" =>$attrs["TYPE"],
							"realm" => $attrs["REALM"],
							"owner" => "");		
	} elseif (strcmp($tagName, "KEEP") == 0) {
		$insideKeep = true;
		$keepCount += 1;
		$keeps[] = array ("name" =>$attrs["NAME"],
							"realm" => $attrs["REALM"],
							"owner" => "",
							"guild" => "",
							"guildurl" => "",
							"guildheraldurl" => "");		
	}	
}

function RealmcharacterData($parser, $data) {    
global $tag, $insideKeep, $insideRelic, $relics, $relicCount, $relicsOwned, $srelicsOwned, $keeps, $keepCount, $keepsOwned, $skeepsOwned, $bgsOwned, $sbgsOwned, $da_serverpopulation, $da_serverstatus;
	if (strcmp($tag, "POPULATION") == 0) {
		$da_serverpopulation .= $data;
	} elseif (strcmp($tag, "STATUS") == 0) {
		$da_serverstatus .= $data;
	} elseif (strcmp($tag, "OWNER") == 0) {
		if ($insideRelic) {
			$relics[$relicCount]["owner"] .= $data;
			$relicsOwned[rtrim($data)] += 1;
			$srelicsOwned[rtrim($data)] += 1;
		} elseif ($insideKeep) {
			$keeps[$keepCount]["owner"] .= $data;
			// BG's have a "realm" of Neutral
			if (strcmp(rtrim($keeps[$keepCount]["realm"]), "Neutral") == 0) {
				$bgsOwned[rtrim($data)] += 1;
				$sbgsOwned[rtrim($data)] += 1;
			} else { 
				$keepsOwned[rtrim($data)] += 1;
				$skeepsOwned[rtrim($data)] += 1;
			}
		}
	} elseif (strcmp($tag, "CLAIMANT") == 0) {
		$keeps[$keepCount]["guild"] .= $data;
	} elseif (strcmp($tag, "CLAIMANT_GUILDURL") == 0) {
		$keeps[$keepCount]["guildurl"] .= $data;
	} elseif (strcmp($tag, "CLAIMANT_HERALDURL") == 0) {
		$keeps[$keepCount]["guildheraldurl"] .= $data;
	}
}

function endRealmElement($parser, $tagName) {    	;
global $servers, $insideRelic, $insideKeep, $da_servername, $da_serverpopulation, $da_serverstatus, $relics, $relicCount, $srelicsOwned, $keeps, $keepCount, $skeepsOwned, $sbgsOwned;
	if (strcmp($tagName, "SERVER") == 0) {
		$servers[] = array("servername"=>$da_servername,
							"serverpop"=>$da_serverpopulation,
							"serverstatus"=>$da_serverstatus,
							"keeparray"=>$keeps,
							"relicarray"=>$relics,
							"relicsOwned"=>$srelicsOwned,
							"keepsOwned"=>$skeepsOwned,
							"bgsOwned"=>$sbgsOwned);
		//New Server, ReInit
		$da_servername = "";
		$da_serverpopulation = "";
		$da_serverstatus = "";
		$relicCount = -1;
		$relics = array();
		$keepCount = -1;
		$keeps = array();	
		$srelicsOwned = array();
		$skeepsOwned = array();
		$sbgsOwned = array();
	} elseif (strcmp($tagName, "RELIC") == 0) {						
		$insideRelic = false;				
	} elseif (strcmp($tagName, "KEEP") == 0) {
		$insideKeep = false;	
	}
}

function show_global() {
global $da_realmboxcontent, $relicsOwned, $keepsOwned, $bgsOwned, $bgA, $bgH, $bgM;
	$da_realmboxcontent .= "<TR><TD colspan=2>Global RvR</TD></TR>";
	$da_realmboxcontent .= "<TR><TD colspan=2 bgcolor=$bgA><FONT size=-2>Albion holds " . (int)$relicsOwned["Albion"] . " relics, " . (int)$keepsOwned["Albion"] . " keeps, " . (int)$bgsOwned["Albion"] . " BGs </FONT></TD></TR>";
	$da_realmboxcontent .= "<TR><TD colspan=2 bgcolor=$bgH><FONT size=-2>Hibernia holds " . (int)$relicsOwned["Hibernia"] . " relics, " . (int)$keepsOwned["Hibernia"] . " keeps, " . (int)$bgsOwned["Hibernia"] . " BGs </FONT></TD></TR>";
	$da_realmboxcontent .= "<TR><TD colspan=2 bgcolor=$bgM><FONT size=-2>Midgard holds " . (int)$relicsOwned["Midgard"] . " relics, " . (int)$keepsOwned["Midgard"] . " keeps, " . (int)$bgsOwned["Midgard"] . " BGs </FONT></TD></TR>";
}

function output_servers() {
	global $da_realmboxcontent, $servers, $yourservername, $bgsOwned, $relicsOwned, $keepsOwned, $showallservers, $showserverinfo, $showglobal, $globsattop, $bgA, $bgH, $bgM, $bgBG, $mythicrealmurl;	
	if (($showglobal) && ($globsattop)) {
		show_global();
	}	
	for($i=0; $i<count($servers); $i++) {
		//Output Server Info		
		if (($showallservers) || (strcmp($servers[$i]["servername"], $yourservername) == 0)) {
			if ($showserverinfo) {		
				$da_realmboxcontent .= "<TR><TD colspan=2><A HREF=$mythicrealmurl";
				$da_realmboxcontent .= $servers[$i]["servername"] . ">";
				$da_realmboxcontent .= $servers[$i]["servername"] . "</A>";
				$da_realmboxcontent .= "</TD><TR></TR><TD><FONT size=-2>[Status:";
				$da_realmboxcontent .= $servers[$i]["serverstatus"];
				$da_realmboxcontent .= "]</font></TD><TD><FONT size=-2>[Pop:";
				$da_realmboxcontent .= $servers[$i]["serverpop"];
				$da_realmboxcontent .= "]<FONT size=-2></TD></TR><TR><TD colspan=2><HR></TD></TR>\n";
			}
			$trelicsOwned = $servers[$i]["relicsOwned"];
			$tkeepsOwned = $servers[$i]["keepsOwned"];
			$tbgsOwned = $servers[$i]["bgsOwned"];
			$da_realmboxcontent .= "<TR><TD colspan=2 bgcolor=$bgA><FONT size=-2>Albion holds " . (int)$trelicsOwned["Albion"] . " relics, " . (int)$tkeepsOwned["Albion"] . " keeps, " . (int)$tbgsOwned["Albion"] . " BGs </FONT></TD></TR>";
			$da_realmboxcontent .= "<TR><TD colspan=2 bgcolor=$bgH><FONT size=-2>Hibernia holds " . (int)$trelicsOwned["Hibernia"] . " relics, " . (int)$tkeepsOwned["Hibernia"] . " keeps, " . (int)$tbgsOwned["Hibernia"] . " BGs </FONT></TD></TR>";
			$da_realmboxcontent .= "<TR><TD colspan=2 bgcolor=$bgM><FONT size=-2>Midgard holds " . (int)$trelicsOwned["Midgard"] . " relics, " . (int)$tkeepsOwned["Midgard"] . " keeps, " . (int)$tbgsOwned["Midgard"] . " BGs </FONT></TD></TR>";

			
			$trelics = $servers[$i]["relicarray"];
			for($j=0; $j<count($trelics); $j++) {
				if (strcmp(rtrim($trelics[$j]["realm"]), "Albion") == 0) {
					$bgc = $bgA;
				} elseif (strcmp(rtrim($trelics[$j]["realm"]), "Hibernia") == 0) {
					$bgc = $bgH;
				} elseif (strcmp(rtrim($trelics[$j]["realm"]), "Midgard") == 0) {
					$bgc = $bgM;
				}
				$da_realmboxcontent .= "<TR><td colspan=2 bgcolor=$bgc><FONT size=-2>";
				$da_realmboxcontent .= $trelics[$j]["realm"];
				$da_realmboxcontent .= "'s ";
				$da_realmboxcontent .= $trelics[$j]["name"];
				$da_realmboxcontent .= "(";
				$da_realmboxcontent .= $trelics[$j]["type"];
				$da_realmboxcontent .= ")";
				$da_realmboxcontent .= "</font></td></TR><TR><TD colspan=2 bgcolor=$bgc><FONT size=-2>Now in: ";
				if (strcmp(rtrim($trelics[$j]["realm"]), rtrim($trelics[$j]["owner"])) == 0) {
					$da_realmboxcontent .= $trelics[$j]["owner"];
				} else {
					$da_realmboxcontent .= "<B>" . $trelics[$j]["owner"] . "</B>";
				}
				$da_realmboxcontent .= "</FONT></TD></TR>\n";	
			}
			$tkeeps = $servers[$i]["keeparray"];
			for($j=0; $j<count($tkeeps); $j++) {
				if (strcmp(rtrim($tkeeps[$j]["realm"]), "Albion") == 0) {
					$bgc = $bgA;
				} elseif (strcmp(rtrim($tkeeps[$j]["realm"]), "Hibernia") == 0) {
					$bgc = $bgH;
				} elseif (strcmp(rtrim($tkeeps[$j]["realm"]), "Midgard") == 0) {
					$bgc = $bgM;
				} else {
					$bgc = $bgBG;
				}
				$da_realmboxcontent .= "<TR><TD bgcolor=$bgc colspan=2><FONT size=-2>";
				if (strcmp(rtrim($tkeeps[$j]["realm"]),"Neutral") == 0) {
					$da_realmboxcontent .= "BattleGround ";
				} else {
					$da_realmboxcontent .= $tkeeps[$j]["realm"];
					$da_realmboxcontent .= "'s ";
				}
				$da_realmboxcontent .= $tkeeps[$j]["name"];
				$da_realmboxcontent .= "</font></TD></TR><TR></TR><TD colspan=2><FONT size=-2><i>Held by: </i>";
				if ((strcmp(rtrim($tkeeps[$j]["realm"]),"Neutral") == 0) || (strcmp(rtrim($tkeeps[$j]["realm"]), rtrim($tkeeps[$j]["owner"])) == 0))  {					
					$da_realmboxcontent .= $tkeeps[$j]["owner"];
				} else {
					$da_realmboxcontent .= "<B>" . $tkeeps[$j]["owner"] . "</B>";				
				}
				$da_realmboxcontent .= "</FONT></TD></TR>\n";
				if (strlen($tkeeps[$j]["guild"]) > 0) {
					$da_realmboxcontent .= "<TR><TD colspan=2><FONT size=-2><i>Claimed: </i><A HREF=";
					$da_realmboxcontent .= $tkeeps[$j]["guildheraldurl"];
					$da_realmboxcontent .= ">";
					$da_realmboxcontent .= $tkeeps[$j]["guild"];
					$da_realmboxcontent .= "</A></FONT>";
					if (!(strcmp(rtrim($tkeeps[$j]["guildurl"]), "No website entered") == 0)) {
						$da_realmboxcontent .= "<FONT size=-2>[<A HREF=";
						$da_realmboxcontent .= $tkeeps[$j]["guildurl"];		
						$da_realmboxcontent .= "><i>Site</i>";		
						$da_realmboxcontent .= "</A>]</FONT>";			
					}	
					$da_realmboxcontent .= "</TD></TR>";		
				}
				
			}
		}		
	}
	if (($showglobal) && (!($globsattop))) {
		show_global();
	}	
}

function make_daoc_realm() {
global $tag, $servers, $da_realmboxcontent, $relics, $relicCount, $relicsOwned, $srelicsOwned, $keeps, $keepCount, $keepsOwned, $skeepsOwned, $bgsOwned, $sbgsOwned, $insideRelic, $insideKeep, $yourservername, $showallservers, $showserverinfo, $showglobal, $globsattop, $bgA, $bgH, $bgM, $bgBG, $mythicrealmurl;
//-------------------------------------------------------------
// Configuration Section
// NOTE: Defaults should work for most people, however most
// People will want to set $yourservername to be the name of
// their home server.
//-------------------------------------------------------------
// NOTE:
// If you want to display RvR Info for ALL the DAoC Servers
// [You probably don't, but it's here if you want it..]
// Set $showallservers=true
//-------------------------------------------------------------
$showallservers=FALSE;
//-------------------------------------------------------------

//-------------------------------------------------------------
// NOTE:
//If $showallservers=false then...
//Change the name here to that of the Server you want to pull 
//Your stats for.  Case is important.  Name must match exactly
//-------------------------------------------------------------
$yourservername="Percival";
//-------------------------------------------------------------

//-------------------------------------------------------------
// NOTE:
//Change $showserverinfo=false if you want to suppress the 
//display of the servername, users and status. You might want
//to do this, if you supply the name of the server explicitly
//and this information is redundant to what you have elsewhere
//on your site.
//-------------------------------------------------------------
$showserverinfo=TRUE;
//-------------------------------------------------------------

//-------------------------------------------------------------
// NOTE:
//Change $showglobal=false if you want to suppress the global 
//stats.
$showglobal=TRUE;
//-------------------------------------------------------------

//-------------------------------------------------------------
// NOTE:
//Change $globsattop=false if you want the global stats to
//appear after the server details as oppossed to before them.
//on your site.
//-------------------------------------------------------------
$globsattop=TRUE;
//-------------------------------------------------------------

//-------------------------------------------------------------
// NOTE:
// Color coding follows the basic convention of associating
// Red for Albion, Green for Hib, and Blue for Midgard.
// Since Battlegrounds are not owned, I chose Purple to
// Represent them where appropriate.

// Change these constants if you want to alter this scheme
// or if it collides with the look and feel of your site.
//
$bgA = "\"#800000\""; // Albion
$bgH = "\"#008000\""; // Hibernia
$bgM = "\"#000080\""; // Midgard
$bgBG = "\"#800080\""; // BattleGrounds
//
//-------------------------------------------------------------
//Really a constant, but if it ever changes, Update here:
$mythicrealmurl="http://www.camelotherald.com/realms/";
//-------------------------------------------------------------

$relics = array();
$relicCount = -1;
//Global Totals
$relicsOwned = array("Albion" => 0, "Hibernia" => 0, "Midgard" => 0);
$keepsOwned = array("Albion" => 0, "Hibernia" => 0, "Midgard" => 0);
$bgsOwned = array("Albion" => 0, "Hibernia" => 0, "Midgard" => 0);
//Server Totals
$srelicsOwned = array("Albion" => 0, "Hibernia" => 0, "Midgard" => 0);
$skeepsOwned = array("Albion" => 0, "Hibernia" => 0, "Midgard" => 0);
$sbgsOwned = array("Albion" => 0, "Hibernia" => 0, "Midgard" => 0);		

$keeps = array();
$keepCount = -1;
$insideRelic = false;
$insideKeep = false;
$servers = array();


// Create an XML parser
$xml_parser = xml_parser_create();

// Set the functions to handle opening and closing tags
xml_set_element_handler($xml_parser, "startRealmElement", "endRealmElement");

// Set the function to handle blocks of character data
xml_set_character_data_handler($xml_parser, "RealmcharacterData");

$da_realmboxcontent = "<TABLE BORDER=0 WIDTH=0%>\n";
$fp = @fopen("http://www.camelotherald.com/xml/servers.xml","r");
if ($fp) {  
	// Read the XML file 4KB at a time
	while ($data = fread($fp, 4096)) {   
		// Parse each 4KB chunk with the XML parser created above
		if (!(xml_parse($xml_parser, $data, feof($fp)))) {
			$da_realmboxcontent .= "XML error:";
			$da_realmboxcontent .= xml_error_string(xml_get_error_code($xml_parser));
			$da_realmboxcontent .= "at line ";
			$da_realmboxcontent .= xml_get_current_line_number($xml_parser);
			break;
		}
	}
	// Close the XML file
	fclose($fp);
} else {
	$da_realmboxcontent .= "<TR><TD>Unavailable</TD></TR>\n";	
}
output_servers();
$da_realmboxcontent .= "</TABLE>\n";
// Free up memory used by the XML parser
xml_parser_free($xml_parser);
return $da_realmboxcontent;
}

$content .= make_daoc_realm();
?>