<?php
//************************************************************************/
//* common.function.php                                                  */
//* ===========================                                          */
//* Copyright (c) 2004 by David Rolston  (gizmo@gizmola.com)             */
//* http://www.gizmola.com                                               */
//*                                                                      */
//* This program is free software. You can redistribute it and/or modify */
//* it under the terms of the GNU General Public License as published by */
//* the Free Software Foundation; either version 2 of the License.       */
//************************************************************************/
//																		                                   */
// Questions or comments can be left at http://forum.gizmola.com    	   */
//************************************************************************/

/**
 * common.function.php is the gamestatus system function library
 * @package GameStatus common.function.php
 * @author David Rolston <gizmo@gizmola.com>
 * @copyright 2004, David Rolston
 */
 
/**
 * function makelookup
 *
 * makelookup is a generic html select (drop down list) generator.  It
 * assumes that that the global database connection variables are in 
 * global scope prior to calling the function. example:
 * <code>
 * <?php
 * makelookup('Status', 'StatusCode', 'Description');
 * ?>
 * </code>
 * 
 * @author David Rolston <gizmo@gizmola.com>
 *
 * @param  string $table name of lookup table. Also used for the select name=
 * @param  string $key name of primary key column of lookup table.  Becomes the value= for each option.
 * @param  string $desc name of Description column from lookup table.  Displayed in the drop-down List of options.
 * @param  string $keyval optional param, that will be the currently 'selected' item in the drop down list.
 * 
 * @return string An html <select> is returned, populated with <option>'s set to the values of the $desc column
 *
 * @global dbhost mysql host string
 * @global dbname mysql database
 * @global dbuser mysql user
 * @global dbpasswd mysql user password
 * 
 */
function makelookup($table, $key, $desc, $keyval = '') {
  global 
		$dbhost, 
		$dbname, 
		$dbuser, 
		$dbpasswd;
	
  $sql = "SELECT $key, $desc FROM $table ORDER BY $desc";
	$dbh = mysql_connect($dbhost, $dbuser, $dbpasswd) or die("Could not connect");
	mysql_select_db($dbname,$dbh) or die("Could not select database");
	$rslt = mysql_query($sql, $dbh) or die("Query failed");
	$s = '<select name="'.$table.'">'."\n";
	
	while ($row = mysql_fetch_assoc($rslt)) {
	  // 
		// Output the options
		//
		$s .= '<option';
		if ($row[$key] == $keyval)
		  $s .= ' selected';
		$s .= ' value="'.$row[$key].'">'.$row[$desc].'</option>'."\n";
	}
	$s .= '</select>'."\n";
  return $s;
}
?>